using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents logout response security message 
	/// defined in VistALink protocol. 
	/// </summary>
	public sealed class SecurityLogoutResponseMessage : SecuritySimpleResponseMessage
	{
		/// <summary>
		/// Message response type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string ResponseType = "AV.Logout";

		/// <summary>
		/// Minimalistic constructor allowing to specify only response status. 
		/// </summary>
		/// <param name="responseStatus">VistALink message response status. Required.</param>
		public SecurityLogoutResponseMessage( ResponseStatus responseStatus )
			: this( responseStatus, null) {}

		/// <summary>
		/// This constructor allows setting informative message for the response (usually, this message
		/// will describe the reason for failure). It also requires response status to be specified. 
		/// </summary>
		/// <param name="responseStatus">VistALink message response status. Required.</param>
		/// <param name="message">Optional informative text message. Expected to be human-readable.</param>
		public SecurityLogoutResponseMessage( ResponseStatus responseStatus, string message ) 
			: base( ResponseType, responseStatus, message ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecurityLogoutResponseMessage( XmlDocument sourceDoc )
			: base( ResponseType, sourceDoc ) {}
	}
}
